/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/




#include "lib.h"
#include "uilib.h"
#include "nttypes.h"
#include "fat.h"


/* directory listing formats */

const String dir_dos_fmt = "%d %t    %f %s";
const String dir_wide_fmt= "%D %f";



/* ======================================================================
 * =  LoadAFile - Loads a file in its entirety to memory.               =
 * ======================================================================
 *  OVERVIEW
 *      This function will load a file into memory.
 *
 *  FORM OF CALL
 * 	LoadAFile(SourceFile, Destination);
 * 
 *  INPUTS
 *      SourceFile:  Filename of the source file.
 *      Destination:  Address where data should be loaded to.
 *
 *  RETURNS
 * 	STATUS_SUCCESS if operation was successful; 
 *      STATUS_FAILURE, otherwise.
 *
 *  AUTHOR
 *      Rogelio R. Cruz, Digital Equipment Corporation, 9/11/95
 */
int LoadAFile ( char * SourceFile, char * Destination )
{
    FILE * FilePtr;
    size_t BytesRead;

    /*
     *  First try to open the file for reading.  If not found
     *  or some type of error is encountered about the operation.
     */
    if ((FilePtr = fopen(SourceFile, "r")) == NULL) {
      mobo_logf( LOG_WARN "FILE: Can't read \"%s\"\n", SourceFile);
      perror("ERROR:  Unable to open specified file");
        return -1;
    }

    /*
     *  Print out some info.
     */
    mobo_logf( LOG_INFO "FILE: Loading %s at address 0x%X\n",
			SourceFile, Destination);

    /*
     *  Read the file and check for errors.
     */
    if ((BytesRead = fload(FilePtr, Destination)) == 0) {
	fclose( FilePtr );
        perror("ERROR:  File load failed");
        return -1;
    }
        
    if (fclose(FilePtr) == EOF) {
        perror("ERROR:  Unexpected error while closing file");
        return -1;
    }

    mobo_logf( LOG_INFO "FILE: Done... %d (0x%X) Bytes read.\n",
			BytesRead, BytesRead);

    return BytesRead;
}



/* ======================================================================
 * =  FileWriteRange - Writes a range of memory to a file.              =
 * ======================================================================
 *  OVERVIEW
 *      This function will write to a file data from a specified memory 
 *      range.
 *
 *  FORM OF CALL
 * 	FileWriteRange(Filename, StartAddress, Size);
 * 
 *  INPUTS
 *      Filename:  Filename of file to be written.
 *      StartAddress:  First byte of range to be copied.
 *      Size:  Number of bytes to copy.
 *
 *  RETURNS
 * 	STATUS_SUCCESS if operation was successful; 
 *      STATUS_FAILURE, otherwise.
 *
 */
DBM_STATUS
FileWriteRange (
                char *Filename,
                void *StartAddress,
                size_t Size
                )
{
    FILE * FilePointer;
    size_t BytesWritten;
    DBM_STATUS Status = STATUS_SUCCESS;

    /*
     *  First try to open the file for writing.  If some type of
     *  error is encountered, abort the operation.
     */
    if ((FilePointer = fopen(Filename, "w")) == NULL) {
        perror("ERROR:  Can't open file for writing");
        return STATUS_FAILURE;
    }

    /*
     *  Print out some info.
     */
    mobo_logf( LOG_INFO "FILE: Saving %dKb to file %s\n",
	Size >> 10, Filename);

    BytesWritten = fwrite( StartAddress, 1, Size, FilePointer);

    /*
     *  Check for errors and report any.
     */
    if (BytesWritten < Size) {
        perror("ERROR:  Couldn't write some or all the data - disk full?");
        Status = STATUS_FAILURE;
    }
        
    if (fclose(FilePointer) == EOF) {
        perror("ERROR:  Unexpected error while closing file");
        Status = STATUS_FAILURE;
    }
    return Status;
}



/* ======================================================================
 * =  FileDirectory - Prints the files in a specified directory.        =
 * ======================================================================
 *  OVERVIEW
 *      This function print out the files in a directory.
 *
 *  FORM OF CALL
 * 	FileDirectory(Directory);
 * 
 *  INPUTS
 *      Directory:  String specifying directory.
 *	opt: Select a listing style; default is DOS, 'w' is wide
 *
 *  RETURNS
 * 	STATUS_SUCCESS if operation was successful; 
 *      STATUS_FAILURE, otherwise.
 *
 *  AUTHOR
 *      Rogelio R. Cruz, Digital Equipment Corporation, 9/11/95
 */
DBM_STATUS
FileDirectory (
                char *Directory,
		char opt
               )
{
    FILE * FilePointer;
    DBM_STATUS Status = STATUS_SUCCESS;
    char * string;
    String dir_fmt;
    int ents_per_line, lcount;

    /*
     *  First try to open the file for reading.  If not found
     *  or some type of error is encountered about the operation.
     */
    if ((FilePointer = fopen(Directory, "d")) == NULL) {
        perror("ERROR:  Can't open source file for reading");
        return STATUS_FAILURE;
    }

    if ( opt == 'w' )	dir_fmt = dir_wide_fmt, ents_per_line = 4;
    else		dir_fmt = dir_dos_fmt,  ents_per_line = 1;

    lcount = 0;
    string = fdir(FilePointer, dir_fmt );
    while (string != NULL) {
        printf_dbm ( string );
	lcount++;
	if ( lcount % ents_per_line == 0 )	printf_dbm("\r");
        string = fdir(NULL, dir_fmt );
    }

    /*
     *  If there are any errors, print them.
     */
    if (errno != NO_ERRORS) {
        perror("ERROR:  Something happened while getting a directory entry");
        Status = STATUS_FAILURE;
    }

    if (fclose(FilePointer) == EOF) {
        perror("ERROR:  Unexpected error while closing file");
        Status = STATUS_FAILURE;
    }
    return Status;
}



/* ======================================================================
 * =  FileCopy - Copies data from source to destination file.           =
 * ======================================================================
 *  OVERVIEW
 *      This function will copy the contents of one file to another.
 *
 *  FORM OF CALL
 * 	FileCopy(SourceFile, DestinationFile);
 * 
 *  INPUTS
 *      SourceFile:  Filename of the source file.
 *      DestinationFile:  Filename of the destination file.
 *
 *  RETURNS
 * 	STATUS_SUCCESS if operation was successful; 
 *      STATUS_FAILURE, otherwise.
 *
 *  AUTHOR
 *      Rogelio R. Cruz, Digital Equipment Corporation, 9/11/95
 */
DBM_STATUS
FileCopy (
          char *SourceFile,
          char *DestinationFile
          )
{
    FILE        *SourcePtr, *DestPtr;
    BOOLEAN     NoErrors;
    ub          Data[512];
    ui          ObjectsRead, ObjectsWritten;


    /*
     *  Open the files and check for errors.
     */
    if ((SourcePtr = fopen(SourceFile, "r")) == NULL) {
        perror("ERROR:  Can't open source file for reading");
        return STATUS_FAILURE;
    }

    if ((DestPtr = fopen(DestinationFile, "w")) == NULL) {
        perror("ERROR:  Can't open destination file for writing");
        fclose(SourcePtr);
        return STATUS_FAILURE;
    }
    mobo_logf( LOG_INFO "FILE: Copying files...\n");
    /*
     *  Copy from source to destination as long as the end-of-file
     *  for the source has not been reached and an error has not been
     *  encountered.
     */
    NoErrors = TRUE;
    while ( (!feof(SourcePtr)) && NoErrors && (errno == NO_ERRORS)) {
        ObjectsRead = fread(Data, 1, 512, SourcePtr);
        ObjectsWritten = fwrite(Data, 1, ObjectsRead, DestPtr);
        if (ObjectsWritten < ObjectsRead) {
            NoErrors = FALSE;
        }
    } /* while */

    if (errno != NO_ERRORS) {
        perror("ERROR:  Something happened while copying the files");
        fclose(DestPtr);
        fclose(SourcePtr);
        return STATUS_FAILURE;
    }

    fclose(DestPtr);
    fclose(SourcePtr);
    mobo_logf( LOG_INFO "FILE: Done...\n");
    return STATUS_SUCCESS;
}


